           CASE ON
           keep     o/extras
           longi    on
           longa    on

setNibble	START
*****************************************************************************
*
* setNibble designed for calling from ORCA/C:
*
* word setNibble(word data, word nibble_value, word offset);
*
* Marc W Wolfgram  4/20/92 10:17:48 PM
*****************************************************************************
*                   123456789
	phb	bRTLd_n_o_
	phk
	plb

	lda	9,s	get nibble offset [0..3]
	and 	#$0003	make sure it's in range
	tay       	y is counter
	asl	a
	tax                          x is mask index
	lda	n_mask,x	get nibble mask
	and      5,s	and with data to clear target

	lda	7,s	get nibble value [0..15]
	and 	#$000f	make sure it's in range

	cpy	#0	check if counter already null
	beq	shift_done	yes... apply to first nibble

shift      asl	a 	shift nibble 4 bits
	asl	a
	asl	a
	asl	a
	dey		decrement counter
	bne	shift	done when counter is 0

shift_done	ora	5,s	apply nibble to data

	pla		bR TLd_n_o_
	sta	5,s
	pla                          TL d_bRo_
	sta	5,s
	pla		d_ bRTL
	plb
	rtl

n_mask	dc	i2'$fff0,$ff0f,$f0ff,$0fff'

           END

getNibble	START
*****************************************************************************
*
* getNibble designed for calling from ORCA/C:
*
* word getNibble(word data, word offset);
*
* Marc W Wolfgram  4/20/92 10:49:37 PM
*****************************************************************************
*
*                   123456789
	phb	bRTLd_o_

	lda	7,s	get nibble offset [0..3]
	and 	#$0003	make sure it's in range
	tay       	y is counter

	lda	5,s	get the source word

	cpy	#0	check if counter already null
	beq	shift_done	yes... apply to first nibble

shift      lsr	a 	shift nibble 4 bits
	lsr	a
	lsr	a
	lsr	a
	dey		decrement counter
	bne	shift	done when counter is 0

shift_done	and 	#000f	clear the other 3 nibbles
	tay		save it for return

	pla		bR TLd_o_
	sta	3,s
	pla                          TL bRo_
	sta	3,s
	tya		d_ bRTL
	plb
	rtl

           END

buildWord	START
*****************************************************************************
*
* buildWord designed for calling from ORCA/C:
*
* word buildWord(word nibble3, word nibble2, word nibble1, word, nibble0)
*
* Marc W Wolfgram  4/20/92 10:58:24 PM
*****************************************************************************
*
*                   123456789abc
	phb	bRTLn3n2n1n0

	lda	11,s	make sure all nibbles are in range
	and	#$000f	[bits 0..3]
	sta	11,s

	lda	9,s
	and	#$000f	[bits 4..7]
	sta	9,s

	lda	7,s
	and	#$000f	[bits 8..1]
	sta	7,s

           lda	5,s
	and	#$000f	[bits 12..15]
	asl	a
	asl	a
	asl	a
	asl	a
           ora      7,s
	asl	a
	asl	a
	asl	a
	asl	a
           ora      9,s
	asl	a
	asl	a
	asl	a
	asl	a
           ora      11,s
	sta	7,s

	pla         	bR TLn3d_n1n0
	sta	7,s
	pla                          TL n3d_bRn0
	sta	7,s
	pla
	pla		d_ bRTL
	plb

 	rtl
           END
